% This function computes the ranking of genes present in features_file
% based on prototype (reference vector)

function [genes, pearson, euclidean] = computeGeneDistances(features_file, prototype)

    fid = fopen(features_file, 'r');
    if(fid < 0)
        fprintf('Cannot open file %s. Abort ranking.\n', features_file);
    end
    
    genes = [];
    all_features = [];
    
    % reads all data
    count = 1;
    while 1
        tline = fgetl(fid);
        if ~ischar(tline), break, end
        data = regexp(tline,'\t','split');
        if length(data) > 3
            genes = [genes; cellstr(data(1))];
            all_features(count,:) = str2num(char(data(3:end)));
            disp(tline)
            count = count + 1;
        else
            fprintf('Discarding gene %s. It has no features.\n', data(1));
        end
    end
    fclose(fid);

    %compute distances
    all_features(count,:) = prototype;
    euclidean = dist(all_features');
    euclidean = euclidean(1:end-1,end);
    pearson = corr(all_features');
    pearson = pearson(1:end-1,end);
    
    genes = char(genes);
    
end